
//
// Przykadowy kod z rozdziau 5.10.1 "Warunki kocowe" ksiki
// "Programming -- Principles and Practice Using C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

class Bad_area { };    // Specjalny typ do raportowania bdw w funkcji area().

// Oblicza pole powierzchni prostokta.
// Zgasza wyjtek Bad_area, gdy pojawi si nieprawidowy argument.
int area1(int length, int width)
{
    if (length<=0 || width <=0) throw Bad_area();
    return length*width;
}

//------------------------------------------------------------------------------

int area(int length, int width)
// Oblicza pole powierzchni prostokta.
// Warunki wstpne: length i width maj wartoci dodatnie.
// Warunek kocowy: zwraca dodatni warto wyznaczajc pole powierzchni.
{
    if (length<=0 || width <=0) error("Warunek wstpny funkcji area().");
    int a =  length*width;
    if (a<=0) error("Warunek kocowy funkcji area().");
    return a;
}

//------------------------------------------------------------------------------

int main()
try
{
    area(2000000000, 2000000000);
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
